import seaborn as sns
import matplotlib.pyplot as plt
import pandas

data = pandas.read_csv('data_total_human.csv')

sns.set_theme(style="ticks")

f, ax = plt.subplots(figsize=(4, 2))

sns.boxplot(x="class", y="value", data=data,width=.3, palette="vlag")

# Add in points to show each observation
sns.stripplot(x="class", y="value", data=data,size=3, color=".3", linewidth=0)

# Tweak the visual presentation
ax.xaxis.grid(True)
ax.set(ylabel="")

plt.savefig('score_total_human.pdf',format='pdf')
plt.show()
